\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 29))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  %ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Cândva o voi vedea"
  subtitle = "(Andrò a vederla un dì)"
  subsubtitle = \markup \center-column {"Requiem pentru Papa Francisc"
    \tiny "26.04.2025"}
  composer = "folclor italian"
  meter = "Andante"
  tagline=""
}

global = {
  \key d \major
  \time 6/8
  \partial 8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Când -- va o voi ve -- dea __
  în pa -- tri -- a ce -- reas -- că;
  te voi ve -- dea, Ma -- ri -- e,
  bu -- cu -- ri -- a mea. __
  În cer, în cer, în Ce -- ruri,
  când -- va te voi ve -- dea. __
  În cer, în cer, în Ce -- ruri,
  când -- va te voi __ ve -- dea. __
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
   Când -- va o voi ve -- dea, __
   îi voi cân -- ta în -- da -- tă
   cu în -- ge -- rii și sfin -- ții
   "în veci" spre a ei "sla - vă."
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Când -- va o voi ve -- dea __
  pe pu -- ru -- rea Fe -- cioa -- ra;
  se va -- năl -- ța la Ce -- ruri
  prea -- mă -- ri -- rea mea. __  
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  Când -- va o voi ve -- dea, __
  lă -- sând a -- ceas -- tă va -- le,
  ea ca -- pu-mi va ple -- ca __ \skip1
  la __ \skip 1 piep -- tul ei. __
}

%menWordsOne = \lyricmode {
 % \set stanza = "1."
 
%}

%menWords = \womenWordsOne

sopMusic = \relative c' {
  a8^\p fis'4^\< e8 fis4 g8 e4.( e4)
  e8\! e4^\mf dis8 e4 g8 fis4. d4
  a8 fis'4 e8 fis4 g8 e4. e
  e4 dis8 e4 fis8 \once \slurDashed d4.( d8) h'8\rest
  fis8^\mf^\< fis4 a8 a4 d8\! d4.^\f d4
  fis,8^\p a4 d,8 fis4 g8 e4.( e4)
  fis8^\mf^\< fis4 a8 a4 d8\! d4.^\f d8 h8\rest
  fis8^\p 
  \partial 4.
  a4 d,8 fis4.( e4) d8 d4.( d4)  
  \bar "|."
}

altMusic = \relative c' {
  a8 fis'4 e8 fis4 g8 e4.( e4)
  e8 e4 dis8 e4 g8 fis4. d4
  a8 d4 cis8 d4 e8 e4. e
  e4 dis8 e4 fis8 \once \slurDashed d4.( d8) h'8\rest 
  fis8 fis4 fis8 fis4 a8 a4. a4
  fis8 fis4 d8 fis4 e8 e4.( e4)
  fis8 fis4 fis8 fis4 a8 a4. a8 h8\rest
  fis8 fis4 d8 d4.( cis4) a8 a4.( a4)
}

tenorMusic = \relative c' {
  a8 a4 g8 a4 h8 a4.( a4)
  h8 a4 a8 g4 g8 fis4. fis4
  a8 a4 g8 a4 h8 a4. a
  a4 a8 g4 g8 \once \slurDashed fis4.( fis8) d8\rest
  fis8^\mf^\< a4 a8 a4 a8\! a4^\f( g8) fis4
  fis8^\p a4 h8 h4 a8 g4.( g4)
  fis8^\mf^\< a4 a8 a4 g8\! fis4.^\f fis8 d8\rest d8\rest
  d4.\rest d2.\rest d4.\rest d4\rest
}  

bassMusic = \relative c {
  a8 d4 cis8 d4 cis8 cis4.( cis4)
  cis8 cis4 cis8 cis4 cis8 d4. d4
  a8 d4 cis8 d4 e8 cis4( h8) a4.
  a4 a8 a( h) cis \once \slurDashed d4.( d8) d8\rest
  d8 d4 d8 d4 d8 d4. d4
  d8 d4 d8 d4 d8 cis4.( cis4)
  d8 d4 d8 d4 d8 d4. d8 d8\rest d8\rest 
}  

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      \addlyrics { \womenWordsFour }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \altMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      \addlyrics { \womenWordsFour }
      \new Voice { \voiceTwo \global \bassMusic }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
    \tempo 4 = 65
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}